﻿var questionnaireStructure = {
    container: null,
    expandAllBlocks: null
}

$(document).ready(function () {
    questionnaireStructure.container = $(".v-structureBlockContainer");
    questionnaireStructure.setBlockEvents();
    questionnaireStructure.setGeneralEvents();
});

questionnaireStructure.setUIElements = function (openQuestions, goToQuestion) {
    var nmbLoadingBlocks = 0;

    questionnaireStructure.container.append("<div class='structure-header-count h-blockStructureHeader'>" + questionnaireEditor.resources.BlocksCount.replace('{0}', questionnaireEditor.blocks.length) + "</div>");

    $(questionnaireEditor.blocks).each(function (index) {
        var blockPanel = document.createElement("div");
        var blockContent = document.createElement("div");
        var blockHeader = document.createElement("div");
        var blockNameContainer = document.createElement("div");
        var selectBlockCheck = "<input type='checkbox' class='block-check force-noprint v-blockCheck'  /> ";
        var blockNameLabel = "<span class=\"v-nameLabel\">" + this.name + "</span>";
        var blockQuestionsCountLabel = "<span class=\"nmb-questions\">" + $(".v-nmbQuestions", $("#blockPanel" + this.blockId)).html() + "</span>";
        var blockIsOpened = $("#blockPanel" + this.blockId + ".expanded").length != 0;
        var inlineOptonsContainer = document.createElement("div");
        var blockOptionsPanel = $(".v-blockOptions", $("#blockPanel" + this.blockId)).clone();
        var options = questionnaireStructure.getDisplayOptions();

        $(".h-editBlock, .h-deleteBlock, .h-copyBlock", blockOptionsPanel).remove();
        $(".option-seperator", blockOptionsPanel).last().remove();

        $(blockPanel).attr("id", this.blockId);
        $(blockPanel).addClass("block-panel v-blockStructurePanel clearfix");
        $(blockContent).addClass("block-content clearfix v-blockContent");
        $(blockHeader).addClass("block-header clearfix");
        $(blockNameContainer).addClass("block-name h-expandStructureBlock");
        $(inlineOptonsContainer).addClass("inline-options block-options hidden v-blockStructureOptions");

        questionnaireStructure.container.append(blockPanel);
        $(blockPanel).append(blockContent);
        $(blockContent).append(blockHeader);
        $(blockHeader).html(selectBlockCheck);
        $(blockHeader).append(blockNameContainer);
        $(blockHeader).append(blockOptionsPanel);

        $(blockNameContainer).html(blockNameLabel + " " + blockQuestionsCountLabel);

        if (blockIsOpened) {
            nmbLoadingBlocks++;
            $(blockPanel).addClass("loading");

            questionnaireStructure.loadBlockContent(this.blockId, blockPanel, true, false, true, openQuestions, options, function () { nmbLoadingBlocks--; });
        }
    });
}

// --------------- GENERAL - events ----------------------------------

questionnaireStructure.setGeneralEvents = function () {
    $(".v-printSelectedStructure").on("click", function () {
        questionnaireStructure.printSelectedQuestions();
    });

    $(".v-PrintAllStructure").on("click", function () {
        //window.location.href = a4.top().questionnaireEditor.getUrl("ViewStructure");  
        modalDialog.showWindow(a4.top().questionnaireEditor.getUrl("ViewStructure", { optionsJSON: JSON.stringify(questionnaireStructure.getDisplayOptions()) }), 750, 1000);
    });
}

questionnaireStructure.loadQuestionnaireSettingsContent = function () {
    a4.callServerMethod(a4.top().questionnaireEditor.getUrl("GetQuestionnaireStructure"), { options: questionnaireStructure.getDisplayOptions() },
        function (result) {
            if (result != "") {
                var qSettings = $(".v-structureQuestionnaireContainer", questionnaireEditor.container);
                qSettings.attr("data-loaded", "true").html(result).show();
            }
        },
        function () { }
    );
}

// --------------- BLOCK - events ------------------------------------

questionnaireStructure.setBlockEvents = function () {
    questionnaireStructure.container.on("click", '.h-expandStructureBlock, .h-expandBlock', function () {
        var parent = $(this).closest(".v-blockStructurePanel");
        if (parent.length > 0)
            questionnaireStructure.toggleBlock($(this));
    });

    questionnaireStructure.container.on("click", ".h-expandStructureQuestion, .h-collapseQuestions", function () {
        questionnaireStructure.toggleQuestion($(this), true);
    });

    $(".v-questionSelector  .v-structureDisplayOptions").on("click", ".v-refreshStructure", function () {
        questionnaireStructure.refreshOpenedBlocks();
    });

    questionnaireStructure.container.on("click", ".v-questions-count", function () {
        var item = $(this).parent();
        $(".block-questions-container", item).toggle();
    });

    questionnaireStructure.container.on("click", ".h-expandQuestions", function () {
        if (questionnaireEditor.isStructureViewMode === true) {
            var block = $(this).closest(".v-blockStructurePanel");
            var questionSelector = ".v-structureQuestionContent";
            questionnaireStructure.initializeExpandCollapse($(questionSelector + ".hidden", block)); 
        }
    });

    questionnaireStructure.container.on("click", ".h-collapseQuestions", function () {
        if (questionnaireEditor.isStructureViewMode === true) {
            var block = $(this).closest(".v-blockStructurePanel");
            var questionSelector = ".v-structureQuestionContent";
            questionnaireStructure.initializeExpandCollapse($(questionSelector + ":not(.hidden)", block));
        }
    });
}

questionnaireStructure.refreshOpenedBlocks = function () {
    var options = questionnaireStructure.getDisplayOptions();
    var qsVisible = $(".v-questionnaire-structure-settings").length > 0;

    // Check if we need to reload the questionnaire settings
    if (options.DisplayQuestionnaireSettings != qsVisible) {
        questionnaireStructure.loadQuestionnaireSettingsContent();
    }

    $(".v-blockStructurePanel.loaded", questionnaireStructure.container).each(function () {
        var questionsContainer = $(".v-questionsContainer", $(this));
        var blockId = $(this).attr("id");
        var blockIsOpened = $(".v-questionsContainer", $(this)).is(":visible");
        var openedQuestions = questionnaireStructure.getOpenedQuestionsIdsOfBlock($(this));

        var options = questionnaireStructure.getDisplayOptions();

        if (blockIsOpened) {
            questionnaireStructure.loadBlockContent(blockId, $(this), true, false, true, openedQuestions, options, null);
        } else {
            questionsContainer.remove();
            $(this).removeClass("loaded");
        }
    });

    $(".v-blockStructurePanel:not(.loaded)", questionnaireStructure.container).each(function () {
        $(".v-block-structure-content", $(this)).toggle(options.DisplayBlockSettings);
    });

    questionnaireStructure.uncheckAllQuestions();
}

questionnaireStructure.completeButtonToggle = function (id, blockPanel, openBlock, findQuestion, callback) {
    $(".v-questionsContainer", blockPanel).toggle(openBlock);

    if (callback != undefined) {
        callback();
    }
}

questionnaireStructure.loadBlockContent = function (id, blockPanel, openBlock, findQuestion, toggle, openQuestions, options, callback) {
    if (options == null) {
        options = questionnaireStructure.getDisplayOptions();
    }

    a4.callServerMethod(a4.top().questionnaireEditor.getUrl("GetBlockStructureItems"), { blockId: id, openQuestions: openQuestions, options: options },
        function (result) {
            if (result != "") {
                $(".v-block-structure-content", blockPanel).remove();
                $(".v-blockContent", blockPanel).append(result);

                $(blockPanel).removeClass("loading").addClass("loaded");
                $("table.basic-structure-table > tbody").find("tr:odd").addClass("odd");

                if (toggle) {
                    questionnaireStructure.completeButtonToggle(id, blockPanel, openBlock, findQuestion, callback);
                } else if (callback) {
                    callback();
                }
            }
        },
        function () { }
    );
}

questionnaireStructure.toggleBlock = function (button, findQuestion, callback, noMoveOnCallback, openQuestions) {
    var blockPanel = button.closest(".v-blockStructurePanel");
    var id = questionnaireStructure.getBlockIdFromElement(blockPanel);
    var options = questionnaireStructure.getDisplayOptions();

    var openBlock = $(".v-questionsContainer", blockPanel).is(":hidden") || $(".v-questionsContainer", blockPanel).length == 0;
    $(".block-header .h-expandBlock:not(.v-blockName)", blockPanel).toggle();
    $(".v-block-structure-content", blockPanel).toggle();    

    if (blockPanel.hasClass("loaded")) {
        questionnaireStructure.completeButtonToggle(id, blockPanel, openBlock, findQuestion, callback);
    }
    else {
        blockPanel.addClass("loading");
        $(".h-waiting-icon", blockPanel).show();

        if (callback && (noMoveOnCallback == undefined || !noMoveOnCallback)) {
            setTimeout(function () {
                $('html, body').animate({
                    scrollTop: blockPanel.offset().top - 20
                }, 500);
            }, 20);
        }

        questionnaireStructure.loadBlockContent(id, blockPanel, openBlock, findQuestion, true, openQuestions, options, callback);
    }
}

questionnaireStructure.toggleQuestion = function (button, withSave) {
    // Toggle current block display and button
    var itemPanel = button.closest(".v-blockItemStructurePanel");
    var questionType = $(".v-questionEdit", itemPanel).attr("data-qtypename");
    var itemHeader = button.closest(".item-header");

    var content = $(".v-structureQuestionContent", itemPanel);

    if (content.hasClass("hidden")) {
        content.removeClass("hidden");
        itemHeader.addClass("opened");
    } else {
        content.addClass("hidden");
        itemHeader.removeClass("opened");
    }


    $(".h-expandStructureQuestion:not(.h-questionTitle)", itemHeader).toggle();

}

questionnaireStructure.completeExpandAll = function () {
    $(".v-blockStructurePanel.loaded", questionnaireStructure.container).each(function () {
        var block = $(this);
        var expand = $(".v-questionsContainer:hidden", block);

        if (expand.length > 0) {
            questionnaireStructure.toggleBlock(expand, false, null);
        }

        var questions = $(".v-structureQuestionContent.hidden", block);
        questionnaireStructure.initializeExpandCollapse(questions);
    });
}

questionnaireStructure.initializeExpandCollapse = function (questions) {
    if (questions.length > 0) {
        $("body").addClass("wait");
        setTimeout(function () { questionnaireStructure.executeExpandCollapse(questions) }, 0);
    }
}

questionnaireStructure.executeExpandCollapse = function (questions) {
    questions.each(function () {
        questionnaireStructure.expandCollapseBlockItem($(this));
    });

    $("body").removeClass("wait");
}

questionnaireStructure.expandCollapseBlockItem = function (questionContent) {
    var item = $(".h-questionTitle", questionContent.prev(".item-header:first"));

    if (item.length > 0) {
        questionnaireStructure.toggleQuestion(item, false);
        //questionnaireStructure.questionMouseLeave(item.closest(".v-blockItemPanel"));
    }
}

questionnaireStructure.verifyAndLoadEmptyBlockedScolledIntoView = function () {
    var found = 0;      // Use variable to only expand first few blocks that are into view (max 3). Reduce current load and create progressive load
    var processedIds = [];

    for (var i = 0; found < 3 && i != questionnaireStructure.expandAllBlocks.length; i++) {
        var block = questionnaireStructure.expandAllBlocks.get(i);

        if (IsScrolledIntoView(block)) {
            var expand = $(".h-expandStructureBlock", block);
            processedIds.push(block.id);
            expand.trigger("click");            
            ++found;
            questionnaireStructure.expandAllBlocks.splice(i--, 1);  // remove current item
        }
    }
}

// --------------- BLOCK - functions ------------------------------------

questionnaireStructure.blockMouseLeave = function (blockPanel) {
    $(".v-blockOptions", blockPanel).hide();
    blockPanel.removeClass("focus");
}

// --------------- GENERAL FUNCTIONS ------------------------------------

questionnaireStructure.printSelectedQuestions = function () {
    var questions = questionnaireStructure.getListSelectedQuestion();
    var options = {
        DisplayQuestionnaireSettings: $("#StructureQuestionnaireSettings").is(":checked"),
        DisplayBlockSettings: $("#StructureBlockSettings").is(":checked"),
        DisplayChoices: $("#StructureChoices").is(":checked"),
        DisplayColumnsAndRows: $("#StructureColumnRows").is(":checked"),
        DisplaySkipLogic: $("#StructureSkipLogic").is(":checked"),
        DisplayAdvanceLogic: $("#StructureAdvanceLogic").is(":checked"),
        DisplayPageBreaks: $("#StructurePageBreaks").is(":checked"),
        DisplayReferences: $("#StructureReferences").is(":checked"),
        DisplaySettings: $("#StructureSettings").is(":checked"),
        DisplayAdvancedSettings: $("#StructureAdvancedSettings").is(":checked"),
        DisplayText: $("#StructureText").is(":checked"),
        DisplayVariables: $("#StructureVariables").is(":checked"),
        DisplayQuestionCheckBox: false,
    };
    
    modalDialog.showWindow(a4.top().questionnaireEditor.getUrl("ViewStructure") + "?listQuestions=" + questions.join() + "&optionsJSON=" + JSON.stringify(options), 750, 1000);
}

questionnaireStructure.getListSelectedQuestion = function () {
    var questions = [];

    $(".v-blockCheck:checked", questionnaireStructure.container).each(function () {
        var blockContainer = $(this).closest(".v-blockStructurePanel");

        $(".v-blockItemStructurePanel", blockContainer).each(function () {
            var item = $(this);
            var isChecked = $(".v-questionCheck", item).is(':checked');

            if (isChecked) {
                questions.push(parseInt(questionnaireEditor.blockController.getBlockItemIdFromElement(item), 10));
            }
        });
    });

    return questions;
}

questionnaireStructure.printWordQPrint = function (isSelectList) {
    var questions = [];  

    if (isSelectList) {
        questions = questionnaireStructure.getListSelectedQuestion();
    }

    var options = questionnaireStructure.getDisplayOptions();
    window.location.href = a4.top().questionnaireEditor.getUrl("PrintStructure") + "?listQuestions=" + questions.join() + "&optionsJSON=" + JSON.stringify(options);
}

questionnaireStructure.checkBlockQuestions = function (block) {
    $(".v-questionCheck", block).each(function (e) {
        $(this).click();
    });
}

questionnaireStructure.uncheckBlockQuestions = function (block) {
    $(".v-questionCheck", block).each(function (e) {
        $(this).attr("checked", false);
    });
}


questionnaireStructure.uncheckAllQuestions = function () {
    $(".v-questionCheck:checked", questionnaireStructure.container).each(function (e) {
        $(this).attr("checked", false);
    });
}

questionnaireStructure.getBlockIdFromElement = function (item) {
    return item.closest(".v-blockStructurePanel").attr("id").replace("blockPanel", "");
}

questionnaireStructure.getDisplayOptions = function () {
    var options = {}
    var optionsPanel = $(".v-questionSelector .v-structureDisplayOptions .v-options");

    options.DisplayQuestionnaireSettings = $("#StructureQuestionnaireSettings", optionsPanel).is(':checked');
    options.DisplayBlockSettings = $("#StructureBlockSettings", optionsPanel).is(':checked');
    options.DisplayAdvanceLogic = $("#StructureAdvanceLogic", optionsPanel).is(':checked');
    options.DisplaySkipLogic = $("#StructureSkipLogic", optionsPanel).is(':checked');
    options.DisplayChoices = $("#StructureChoices", optionsPanel).is(':checked');
    options.DisplayVariables = $("#StructureVariables", optionsPanel).is(':checked');
    options.DisplayReferences = $("#StructureReferences", optionsPanel).is(':checked');
    options.DisplayText = $("#StructureText", optionsPanel).is(':checked');
    options.DisplayColumnsAndRows = $("#StructureColumnRows", optionsPanel).is(':checked');
    options.DisplaySettings = $("#StructureSettings", optionsPanel).is(':checked');
    options.DisplayAdvancedSettings = $("#StructureAdvancedSettings", optionsPanel).is(':checked');
    options.DisplayPageBreaks = $("#StructurePageBreaks", optionsPanel).is(':checked');

    return options;
}

questionnaireStructure.getBlockElementFromId = function (itemId) {
    return $("#" + itemId + ".block-panel", questionnaireStructure.container);
}

questionnaireStructure.getBlockItemElementInBlockWithId = function (block, itemId) {
    return $("#blockItemPanel" + itemId, block);
}

questionnaireStructure.getOpenedQuestionsIdsOfBlock = function (blockPanel) {
    var ids = [];

    $(".v-questionsContainer .v-blockItemStructurePanel .v-structureQuestionContent:not(.hidden)", blockPanel).each(function () {
        ids.push($(this).closest(".v-blockItemStructurePanel").attr("id").replace("blockItemPanel", ""));
    });

    return ids;
}